class Mutator_HUDMutator expands Mutator;

var PlayerPawn Player;

simulated function PostRender(canvas Canvas)
{
local int Y,i;
local Bot B;
local PlayerPawn P;
local string Enemies[32];
local int EnemiesCount[32];

	// Call original PostRender first
	Super.PostRender(Canvas);

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	foreach AllActors(class'Bot', B)
		{
		for (i=0;i<32;i++)
			{
			if (B.PlayerReplicationInfo.PlayerName == Enemies[i] || Enemies[i] == "")
				{
				Enemies[i] = B.PlayerReplicationInfo.PlayerName;
				EnemiesCount[i]++;
				i=50;
				}
			}
		}
	Canvas.Font = Font'WhiteFont';
	Canvas.DrawColor = RedColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(0, 128);
	Canvas.DrawText("Enemies:", False);
	Y = 24;
	for (i=0;i<32;i++)
		{
		if (Enemies[i] != "" && EnemiesCount[i] > 0)
			{
			Canvas.SetPos(0, 128 + Y);
			Canvas.DrawText(Enemies[i]$": "@EnemiesCount[i], False);
			Y += 12;
			}
		}
	Y += 24;
	Canvas.SetPos(0, 128 + Y);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Heroes:", False);
	Y += 24;

	foreach AllActors(class'PlayerPawn', P)
		{
		Canvas.SetPos(0, 128 + Y);
		Canvas.DrawText(P.PlayerReplicationInfo.PlayerName, False);
		Y += 12;
		}


	// make next HUD mutator able to draw also
	if (NextHUDMutator != None)
		NextHUDMutator.PostRender(Canvas);

}


defaultproperties
{
	bHidden=True
}